﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class General : UserControl
    {

        private HALFirmwareDevice Dev = null;

        public General()
        {
            InitializeComponent();
        }

        public void SetDevice(HALFirmwareDevice D)
        {
            Dev = D;
        }

        private void btn_ResetToDefaults_Click(object sender, EventArgs e)
        {
            Dev.ResetToDefaultSettings();
        }

        private void btn_ShowDebugForm_Click(object sender, EventArgs e)
        {
            if (Dev == null) return;
            Form F = Dev.CreateDebugForm();
            if (F == null) return;
            F.Show(this);
        }

        private void btn_WriteDebugTrace_Click(object sender, EventArgs e)
        {
            try
            {
                // This writes to the default file location. You can also specify a different file location 
                Dev.WriteDebugTraceFile();

                // We display this file to the user by default
                System.Diagnostics.Process.Start(Dev.DebugTraceFileName);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }


    }
}
